(function(angular) {
    /* update on 18/1/2018 */
    'use strict';   
    var app =  angular.module('webApp', ['ngSanitize']);    
    app.run(function($http, $rootScope){
        if(window.location.pathname==='/home.html'){
            if ($.jStorage.get('selected_restaurant')){
                 window.restId = $.jStorage.get('selected_restaurant');
            }else{
                if(App.checkPrivateMode()){                    
                    $.jStorage.set('selected_action',App.getUrlVars()['act']);
                    window.restId=App.getUrlVars()['id'];                    
                }else{
                    window.location.href="/";
                }
            }
        }
        if ($.jStorage.get('oauth.token')) {           
            $http.get(apiUrl + "/auth/token/" + $.jStorage.get('oauth.token'))
            .success(function(data) {
                if(data.valid){
                    $.jStorage.set("isAuthenticated", true);
                    $http.post(apiUrl + "/user/location",{city_id:cityId,token: $.jStorage.get('oauth.token')},'');
                    var url = apiUrl+'/restaurant/details/'+restId+'?token='+$.jStorage.get('oauth.token');
                    $http.get(url).then(function (response){  
                        App.currentRestaurant = response.data;
                        $rootScope.$broadcast('authenticated');
                    });
                }else{
                    $.jStorage.deleteKey('oauth.token');
                    $.jStorage.set("isAuthenticated", false);                    
                    $http.post(apiUrl + "/auth/token",'',window.apiConfig)
                        .success(function(data) {
                            if (data.token) { 
                                $.jStorage.set("oauth.token", data.token);
                                $.jStorage.setTTL("oauth.token", 315360000000);
                                $.jStorage.set('isAuthenticated', true);
                                $http.post(apiUrl + "/user/location",{city_id:cityId,token: $.jStorage.get('oauth.token')},'');
                                var url = apiUrl+'/restaurant/details/'+restId+'?token='+$.jStorage.get('oauth.token');
                                $http.get(url).then(function (response){  
                                    App.currentRestaurant = response.data;
                                    $rootScope.$broadcast('authenticated');
                                });                                                          
                            }
                        }).error(function() {  console.log('error in api');  });
                }
            }).error(function() { console.log('error in api'); });
        }else{
            var isAuthenticated = $.jStorage.get("isAuthenticated");
            if (!isAuthenticated) {
                    $http.post(apiUrl + "/auth/token",'',window.apiConfig)
                        .success(function(data) {
                            if (data.token) { 
                                $.jStorage.set("oauth.token", data.token);
                                $.jStorage.setTTL("oauth.token", 315360000000);
                                $.jStorage.set('isAuthenticated', true);
                                $http.post(apiUrl + "/user/location",{city_id:cityId,token: $.jStorage.get('oauth.token')},'');
                                var url = apiUrl+'/restaurant/details/'+restId+'?token='+$.jStorage.get('oauth.token');
                                $http.get(url).then(function (response){  
                                    App.currentRestaurant = response.data;
                                    $rootScope.$broadcast('authenticated');
                                });
                            }
                        }).error(function() {  console.log('error in api');  });
            } else {
                $.jStorage.setTTL("oauth.token", 315360000000);
                $http.post(apiUrl + "/user/location",{city_id:cityId,token: $.jStorage.get('oauth.token')},'');
                var url = apiUrl+'/restaurant/details/'+restId+'?token='+$.jStorage.get('oauth.token');
                $http.get(url).then(function (response){  
                    App.currentRestaurant = response.data;
                    $rootScope.$broadcast('authenticated');
                });
            }        
        }
    });
    app.controller('overviewController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){            
         App.catering_datepicker();
         var url = apiUrl+'/restaurant/overview/'+restId+'?token='+$.jStorage.get('oauth.token');          
         $http.get(url).then(function (response){
             var script = document.createElement('script');
             script.type = 'text/javascript';
             script.src = 'https://maps.googleapis.com/maps/api/js?v='+App.currentRestaurant.google_key_version +
                 '&key=' + App.currentRestaurant.google_map_key +'&libraries=places,geometry';
             document.head.appendChild(script);
                $scope.restaurantData = App.currentRestaurant;
                $scope.overview = response.data; 
                $scope.features = response.data.features.detail;
                $scope.isDineMore =function() {                   
                    return App.currentRestaurant.tags_fct.indexOf("dine-more")!==-1 ;                                
                };              
                $scope.getIcon=function(features_key) {                   
                   return "greenP_"+features_key.replace(/[- \/&]/g,'_')+"_Icon" ;               
                };
                $scope.getMainImage=function() {                   
                   return App.currentRestaurant.base_url+ App.currentRestaurant.res_code+"/"+App.currentRestaurant.restaurant_image_name;               
                };
                App.renderCalender(response.data.calendar);
            });
        }); 
    }]);
    app.controller('dmController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){
            $scope.isDM =function() {                   
                    return App.currentRestaurant.tags_fct.indexOf("dine-more")!==-1 ;                                
            };             
            $scope.goToDMpage =function() { 
               return window.webUrl+"restaurants/"+ App.currentRestaurant.name+"/"+App.currentRestaurant.id+"/dine-more";               
            };
            $scope.joinNow = function(){
              //ga('send', 'event', 'Dine&More ' +App.currentRestaurant.name, "Join Now" , "Click_on_join_now_Button", 1, true);
                dataLayer.push({
                    'event':'Join Now',
                    'restname': App.currentRestaurant.name,
                    'ev_label' : 'Click_on_join_now_Button',
                    'RestaurantID':restId,
                }); 
            };
        }); 
    }]);
    app.controller('contactController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){ 
            $scope.restaurant =  App.currentRestaurant ; 
            $scope.restaurant.phone_no = App.formattedPhoneNo(App.currentRestaurant.phone_no);
            $scope.restaurant.stateCode = stateCode ;
           // google.maps.event.addDomListener(window, 'load', App.renderMap);  
            $scope.reserve_table = function(restname,url){
                //ga('send', 'event', restname, "Reserve a table Click" , "Click_on_reserve_a_table_button_in_"+restname.replace(' ','_')+"_contact", 1, true);
                  dataLayer.push({
                    'event':'Reserve a table Click',
                    'restname': App.currentRestaurant.name,
                    'ev_label': "Click_on_reserve_a_table_button_in_"+restname.replace(' ','_')+"_contact",
                    'RestaurantID':restId
                });
                window.open(url,'_blank');
            };
            App.checkMap();
        });       
    }]);
    app.controller('storyController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){ 
        var url = apiUrl+'/restaurant/story/'+restId+'?token='+$.jStorage.get('oauth.token');           
            $http.get(url).then(function (response){
                if(response.data.section_list ){
                    $('.btn_readourstory').removeClass('hide');
                    $scope.stories = response.data.section_list; 
                    $scope.storiesTitle = response.data.story_title;
                    $scope.getImage=function(imageurl) {
                        if(imageurl!==''){
                            return response.data.base_url+imageurl;
                        }
                        return imageurl;
                    };
                    $scope.isEmpty = function(obj) {
                        for(var prop in obj) {
                            if(obj.hasOwnProperty(prop))
                                return false;
                        }
                        return true;
                    }; 
                }else{
                    $('.btn_readourstory').addClass('hide');
                }
            });
        }); 
    }]);
    app.controller('gallaryController', ['$scope', '$http', function ($scope, $http, $rootScope) {
            $scope.$on('authenticated', function(){ 
            var url = apiUrl+'/restaurant/magallery/'+restId+'?token='+$.jStorage.get('oauth.token');           
                $http.get(url).then(function (response){ 
                    var restaurant_images = response.data.restaurant_images.images;
                    var images_path = response.data.restaurant_images.base_url+App.currentRestaurant.res_code+"/";
                    var gallery = []; 
                    var i=1;
                    var isloop = true;
                    if(App.mobileDevice() || ($(window).width() < 1024)){
                        $scope.limit=10;
                        isloop = false;
                    }
                    _.each(restaurant_images,function(img){
                        if(i<= gallaryImgCnt){
                            gallery.push({id:i,imgurl:images_path+img.image,title:img.title});
                            i++;
                        }
                    });
                    $scope.galleries = gallery; 
                    $scope.limit = window.gallaryImgCnt;
                    
                        setTimeout(function(){
                            $('.galleryslider').owlCarousel({
                              items: 1,
                              nav:true,                           
                              loop: isloop,
                              margin: 0,
                              autoplay:true,
                              smartSpeed:1000,
                              
                          });
                            $('.homegalleryslider').owlCarousel({
                                lazyLoad:true,
                                items:1,
                                autoplay: true,
                                smartSpeed: 1500,
                                nav:true,
                                dots: true,
                                loop : true
                            });
                        },500);
                });
            }); 
        }]);
    app.controller('footerController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){
                $scope.fdata =App.currentRestaurant;                
                $scope.isEmpty = function(obj) {
                    for(var prop in obj) {
                        if(obj.hasOwnProperty(prop))
                            return false;
                    }
                    return true;
                };                            
            });       
    }]);
    app.controller('reviewsController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){
                var socialmediaactivity = apiUrl+'/restaurant/socialmediaactivity/'+restId+'?token='+$.jStorage.get('oauth.token');           
                $http.get(socialmediaactivity).then(function (response){
                    $('.review_follow').removeClass('hide');
                    $scope.socialmediaactivity = response.data;
                }); 

                var review = apiUrl+'/restaurant/review/'+restId+'?token='+$.jStorage.get('oauth.token');           
                $http.get(review).then(function (response){
                    $scope.review = response.data;
                });                 

                $scope.fdata =App.currentRestaurant;                
                $scope.isEmpty = function(obj) {
                    for(var prop in obj) {
                        if(obj.hasOwnProperty(prop))
                            return false;
                    }
                    return true;
                };                            
            });       
    }]);
    app.controller('restaurantsController', ['$scope', '$http', function ($scope, $http, $rootScope) {
            $scope.$on('authenticated', function(){ 
            /*var url = apiUrl+'/restaurant/deals-coupons/'+restId+'?token='+$.jStorage.get('oauth.token');  */         
                $http.get('./restaurant.json').then(function (response){                          
                    $scope.restaurants = response.data;
                    $scope.action=function(act,id, reservationurl) {
                        $.jStorage.set('selected_restaurant',id);  
                        $.jStorage.set('selected_action',act);
                        $.jStorage.set('third_party_reservation', reservationurl);                     
                        if(App.checkPrivateMode()){
                            window.location.href='home.html?id='+id+'&act='+act;
                        }else{
                            window.location.href='home.html';
                        }
                        //ga('send', 'event', 'Delivery Location Order', name +" Click" , "Click_on_delivery_lacations", 1, true);
                    };
                    
                });
            }); 
        }]);
    app.controller('dealController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){ 
        var url = apiUrl+'/restaurant/deals-coupons/'+restId+'?token='+$.jStorage.get('oauth.token');           
            $http.get(url).then(function (response){
                App.restaurantDeal = response.data;
                if(App.restaurantDeal.length >0){
                    $('.sticky_deal').removeClass('hide').addClass('hasDeal');       
                }
                $scope.deals = response.data;
                $scope.startDate=function(date) {  
                    if (typeof date === 'string') {
                        date = date.replace(/\-/g, '/');
                    }
                    var dateOut = new Date(date);
                    return dateOut.getDate()+'/'+ (dateOut.getMonth()+1) +'/'+dateOut.getFullYear();                   
                };
                App.renderCart(); 
            });
        }); 
    }]);
    app.controller('promocodeController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){ 
        var url = apiUrl+'/restaurant/mapromocode?token='+$.jStorage.get('oauth.token')+'&restaurantid='+restId;
            $http.get(url).then(function (response){
                $scope.promocode = response.data.promocode;
                if($scope.promocode.length >0){
                    $('.y_sticky_promocode').removeClass('hide');       
                }
                $scope.startDate=function(date) {  
                    if (typeof date === 'string') {
                        date = date.replace(/\-/g, '/');
                    }
                    var dateOut = new Date(date);
                    return dateOut.getDate()+'/'+ (dateOut.getMonth()+1) +'/'+dateOut.getFullYear();                   
                };
            });
        }); 
    }]);
    app.controller('career', ['$scope', '$http', function ($scope, $http, $rootScope) {
         $scope.$on('authenticated', function(){
            $scope.careersubmit=function(){
                App.careersubmit();
            };
        });
    }]);       
    app.controller('menuController', ['$scope', '$http', function ($scope, $http, $rootScope) {
        $scope.$on('authenticated', function(){
            if ($.jStorage.get('selected_action')){
                if($.jStorage.get('selected_action')==='r'){
                    //ga('send', 'event', App.currentRestaurant.name , "Reserve a table Click" , "Click_on_reserve_a_table_button_contact", 1, true);
                      dataLayer.push({
                        'event':'Reserve a table Click',
                        'restname': App.currentRestaurant.name,
                        'ev_label': "Click_on_reserve_a_table_button_contact",
                        'RestaurantID':restId
                    });
                    App.reserveATable();
                }
                if($.jStorage.get('selected_action')==='o'){
                    //ga('send', 'event', App.currentRestaurant.name , "Order Online Click" , "Click_on_order_online_button_contact", 1, true);
                      dataLayer.push({
                        'event':'Order Online Click',
                        'restaurant_name': App.currentRestaurant.name,
                        'ev_label': "Click_on_order_online_button_contact",
                        'RestaurantID':restId
                    });
                    setTimeout(function(){
                        $('html, body').stop().animate({scrollTop:$('#menu').offset().top - 50}, "slow");  
                    },5000);                             
                }
                if($.jStorage.get('third_party_reservation') === 'javascript:void(0)'){
                    $('.y-third_party_reservation').addClass('hide');
                }
            }
            App.imagePath = $scope.imagePath = App.currentRestaurant.base_url + App.currentRestaurant.res_code+"/thumb/";
            var url = apiUrl+'/restaurant/menu/'+restId+'?token='+$.jStorage.get('oauth.token');
            $http.get(url).then(function (response){                
                $scope.dishes = response.data.menu;
                $scope.dishes.minDelivery = App.currentRestaurant.minimum_delivery;
                App.renderCart();
                setTimeout(function(){        
                    switch(window.location.hash){
                        case "#!reserve_a_table":
                            //App.reserveATable();
                            break;
                        default :
                            if(window.location.hash !== ''){
                                var id = (window.location.hash).replace('!', '').split('?');
                                if($(id).length){
                                    $('html, body').stop().animate({scrollTop: $(id[0]).offset().top}, "slow");
                                }
                            }

                    }
                }, 3000);                        
                if(!$.jStorage.get('order_items_'+restId)){
                    $.jStorage.set('order_items_'+restId,[]);
                }
                /*App.closeStripSettings();*/
                $('.t-menu-render').removeClass('hide');
                new WOW().init();
                setTimeout(function(){ 
                    $('#pageload').css('display', '');
                    $('#mainloader').addClass('hide');
                }, 300);
                $('.res_menu').addClass('_vhidden');
                setTimeout(function(){ 
                    App.menupanel();
                    App.entryIntend();
                    $('.res_menu').removeClass('_vhidden');
                }, 500);
                $scope.isEmpty = function(obj) {
                    for(var prop in obj) {
                        if(obj.hasOwnProperty(prop))
                            return false;
                    }
                    return true;
                };
                $scope.isDMDeal = function(title) {
                    if(title==="Dine & More Specials"){
                        return "dmdeal";
                    }
                    return "";
                };
                $scope.showTab=function(id,name){
                    if((App.mobileDevice()) || ($(window).width() < 992)){
                        if($('.tab_'+id).hasClass('active')){
                            $('.tabs,.menu_container').removeClass('active mobiletabactive').addClass('deactive');
                            $('.tab_'+id).addClass('mobiletabactive');
                            $('.menu_'+id).addClass('mobiletabactive');
                        }else{
                            $('.tabs,.menu_container').removeClass('active mobiletabactive').addClass('deactive');  
                            $('.tab_'+id).addClass('active').removeClass('deactive');
                            $('.menu_'+id).addClass('active').removeClass('deactive');
                        }
                    }else{                      
                        $('.tabs').removeClass('active mobiletabactive').addClass('deactive');  
                        $('.tab_'+id).addClass('active').removeClass('deactive');        
                        $('.menu_container').removeClass('active mobiletabactive').addClass('deactive ');
                        $('.menu_'+id).addClass('active').removeClass('deactive');  
                    }
                    App.menupanel();                      
                    if($(window).width() > 992){
                        $('html, body').stop().animate({scrollTop:$('.res_menu').offset().top - 120}, "slow");
                    }else{
                        $('html, body').stop().animate({scrollTop:$('.menu_'+id).offset().top - 100}, "slow");
                    }
                    if (typeof name !== "undefined") {
                      // ga('send', 'event', 'Menu '+App.currentRestaurant.name, name+" Click" , "Click_on_"+name+"_in_Menu", 1, true);
                      dataLayer.push({
                        'event': 'Sub Menu Click',
                        'catname': name,
                        'restname': App.currentRestaurant.name,
                        'ev_label': "Click_on_"+name+"_in_Menu",
                        'RestaurantID':restId
                    });
                    } 
                };
                $.jStorage.set('selected_action','');
                $scope.addToOrder=function(model){
                    if(model.online_order_allowed==0){                    
                        return false ; 
                    }
                    App.addons=[];
                    $('.loader_'+model.item_id).removeClass('hide');
                    //ga('send', 'event', 'Menu Item '+App.currentRestaurant.name, "Add to Cart" , "Click_on_Add_to_Cart_Button", 1, true);
                      dataLayer.push({
                        'event':'Add to Cart',
                        'restname': App.currentRestaurant.name,
                        'ev_label': "Click_on_Add_to_Cart_Button",
                        'RestaurantID':restId
                    });
                    model.quantity = 1 ;
                    model.special_instruction = "" ;  
                    model.price_id=0;
                    model.uid= _.uniqueId(model.item_id+"_");
                    
                    if(($.jStorage.get('order_type_'+restId)==='delivery' && $.jStorage.get('can_deliver_'+restId)===false) || ($.jStorage.get('order_type_'+restId)=='delivery' && $.jStorage.get('can_deliver_'+restId)===null)){
                        App.setJStorage('addtoOrder',model);
                        App.geoSearchAddress();
                        return false;
                    }
                    $(".close").click(function () {
                        App.popuphide();
                    });
                    var url = apiUrl+'/restaurant/menu-addons/'+model.item_id+'?token='+$.jStorage.get('oauth.token');
                    $http.get(url).success(function (mdl){ 
                        App.popupshow();
                        var tmpl = _.template($("#tmpl-popup").html());
                        $('.t-popupdata').html(tmpl(model));
                        App.renderAddOns(model.prices[0].id,[],mdl);
                        window.addOnsModel=mdl;
                        $(".y_price_select").off('change');
                        $(".y_price_select").on('change', $.proxy(App.changeItemPrice,App));
                        $('.loader_'+model.item_id).addClass('hide');
                        $(".add-to-order").click(function () {
                           /* Radio Checkbox Validation with respective to its Selection Type */
                            var radioValidated = true;
                            var i=0;
                            _.each($(".addon-collection[data-selection-type=0]"),function(addonGroup){
                                var parent = $(addonGroup);
                                if(!$(":checked",parent).length) {
                                    $(".addon-error-message",parent).removeClass("hide");                   
                                    if(i===0){                   
                                        var container = $('.a_scroll'),
                                        scrollTo = $(".addon-error-message",parent);
                                        container.animate({
                                            scrollTop: scrollTo.offset().top - container.offset().top + container.scrollTop()-50
                                        });
                                        i++;                        
                                    }                    
                                    radioValidated = false;
                                }else{
                                    $(".addon-error-message",parent).addClass("hide");                    
                                }
                            });

                            if(!radioValidated) {
                                return false;
                            }                    
                            /**************end validation**************/
                            var order_items = [];
                            if($.jStorage.get('order_items_'+restId).length>0){
                                order_items = $.jStorage.get('order_items_'+restId);
                            }
                            var addons = [];
                            App.addons=[];
                           _.each($(".addon-collection"),function(addons){
                               var addon = $(addons);
                               var data = addon.data();
                               var selectionType = data['selectionType'];
                               var inputType = "checkbox";
                               if(parseInt(selectionType,10) === 0){
                                   inputType = "radio";           
                               }
                               var options = $("input[type="+inputType+"]:checked",addon);

                               if(options.length){ 
                                   var cnt = 0 ,i=0;
                                   var addonId = 0;
                                   _.each(options,function(option){                
                                       var freeAddons =parseInt($(option).data().freeAddons) ;
                                       var addons = $(option).data() ;
                                       if(freeAddons >0){                    
                                           if((addonId === 0) || (addonId == $(option).data().addonId)){                       
                                               if(cnt < freeAddons){                          
                                                   addons.isFree=true ;                           
                                                   addons.priority=cnt+1 ;
                                                   cnt++ ;
                                               }else{
                                                   addons.isFree=false ;
                                                   addons.priority=i+1 ;
                                               }                        
                                           }else{                      
                                               addons.isFree=false ;
                                               addons.priority=i+1 ;
                                           }                   
                                       }else{                   
                                           addons.isFree=false ;
                                           addons.priority=i+1 ;
                                       }
                                       addonId = addons.addonId ; 
                                       App.addons.push(addons);               
                                       i++ ; 
                                   },this);            
                               }            
                           });
                           if(App.addons){
                               addons=App.addons;
                           }
                            var special_instruction = $(".menu_special_instruction_item").val();
                            special_instruction = $('<div />').text(special_instruction).html();
                            var items={  
                                "uid": $('#uid').val(),
                                "id": order_items.length,
                                "item_id": $('#item_id').val(),
                                "item_image_url":$('#item_image_url').val(),
                                "item_name": $('#item_name').val(),
                                "item_desc": $('#item_desc').val(),
                                "prices":model.prices,
                                "quantity": $('#quantity').val(),
                                "price_id": $('#price_id').val(),
                                "price_desc": $('#price_desc').val(),
                                "item_price": $('#item_price').val(),
                                "sub_total": $('.sub-total').html(),                        
                                "total_item_price": $('.total').html(),
                                "special_instruction": special_instruction,
                                "addons": addons
                            };
                            order_items.push(items);
                            $.jStorage.set('order_items_'+restId,order_items);  
                            App.showTooltip($('#item_name').val());
                            App.addons=[];
                            App.popuphide();
                            App.renderItems();
                           // ga('send', 'event', 'Menu Item '+App.currentRestaurant.name, "Add to Order" , "Click_on_Add_to_Order_Button", 1, true);
                              dataLayer.push({
                                'event':'Add to Order',
                                'restname': App.currentRestaurant.name,
                                'ev_label': "Click_on_Add_to_Order_Button",
                                'RestaurantID':restId
                            });
                            addMenuTrackingCodes(items);
                        });
                        $(".add-multiplier").click(function () {
                            App.addMultipler();
                        });
                        $(".subtract-multiplier").click(function () {
                            App.subtractMultipler();  
                        });
                        $(".menu_special_instruction_item").click(function () {
                            App.textCounter();
                        });
                        $(".menu_special_instruction_item").keyup(function () {
                            App.textCounter();
                        });
                        $(".menu_special_instruction_item").blur(function () {
                            App.textCounterHide();
                        });
                  });  
                };
                $scope.bookTable=function(){                
                    $("#btnconfirm").off('click');
                    $("#btnconfirm").on('click', $.proxy(App.reserveTable,App));
                };                      
                $scope.checkOut=function(){                
                    App.goToCheckout();               
                };
                $scope.promocode=function(){
                    App.applyPromocode();
                };
                $scope.editPromo=function(){
                    $('.y-promocode-apply, .t_promocode,.y-promocode-control').addClass('hide');
                    $('.y-promocode').removeClass('hide');
                    $('#promocode').val($.jStorage.get("promocode"));
                    $('.y-promocode-amount').html('');
                    $('.y-promocode-coupan').html('');
                    $('.y-dealtext').addClass('hide').html('');
                };
                $scope.removePromo=function(){
                    App.setJStorage("promocode_data","");
                    App.setJStorage("promocode","");
                    App.setJStorage("promocode_status","invalid");          
                    App.cartCalution();
                };
                $scope.locationpopup=function(e){                   
                    App.locationPopup(e);
                };
            });          
        });
        /*
        app.controller('focusCtrl', function($scope){
            $scope.ngFocus = true;
        })*/
        
    }]);
     
})(window.angular);